# import_edge_data.ps1

# 1. Detect Dynamic Paths
$VpnDir = $PSScriptRoot
$ChromeProfile = "$VpnDir\chrome_data\Default"
$EdgeProfile = "$env:LOCALAPPDATA\Microsoft\Edge\User Data\Default"
$Launcher = "$VpnDir\start_vpn_browser.bat"
$IconTarget = "$VpnDir\chrome\chrome.exe"

Write-Host "Detected VPN Location: $VpnDir"

# 2. Kill Browsers to ensure files are unlocked
Write-Host "Closing browsers to unlock files..."
Stop-Process -Name msedge -ErrorAction SilentlyContinue
Stop-Process -Name chrome -ErrorAction SilentlyContinue

# 3. Create Destination Profile
if (-not (Test-Path $ChromeProfile)) {
    New-Item -ItemType Directory -Force -Path $ChromeProfile | Out-Null
}

# 4. Import Data (Bookmarks & Favicons)
Write-Host "Importing Bookmarks from Edge..."
if (Test-Path $EdgeProfile) {
    $FilesToCopy = @("Bookmarks", "Favicons", "History") 
    foreach ($File in $FilesToCopy) {
        if (Test-Path "$EdgeProfile\$File") {
            Copy-Item "$EdgeProfile\$File" "$ChromeProfile\$File" -Force
            Write-Host "  [+] Imported $File"
        } else {
            Write-Host "  [-] $File not found in Edge."
        }
    }
} else {
    Write-Host "[-] Edge profile not found at: $EdgeProfile"
}

# 5. Create Desktop Shortcut (Pointing to this dynamic location)
Write-Host "Creating Desktop Shortcut..."
$WScript = New-Object -ComObject WScript.Shell
$DesktopPath = [System.Environment]::GetFolderPath('Desktop')
$Shortcut = $WScript.CreateShortcut("$DesktopPath\RooGPT VPN Browser.lnk")
$Shortcut.TargetPath = $Launcher
$Shortcut.WorkingDirectory = $VpnDir
$Shortcut.IconLocation = "$IconTarget,0"
$Shortcut.Description = "Private VPN Browser (RooGPT)"
$Shortcut.Save()

# 6. Start Menu Shortcut
$StartMenuPath = "$env:APPDATA\Microsoft\Windows\Start Menu\Programs"
$StartShortcut = $WScript.CreateShortcut("$StartMenuPath\RooGPT VPN Browser.lnk")
$StartShortcut.TargetPath = $Launcher
$StartShortcut.WorkingDirectory = $VpnDir
$StartShortcut.IconLocation = "$IconTarget,0"
$StartShortcut.Save()

Write-Host "Done! Shortcut updated to point to: $VpnDir"
Write-Host "You can now distribute this folder. Run this script on the new PC to setup shortcuts/import."
Pause
